jQuery(document).ready(function($) {
    function fetchPosts(page = 1) {
        const selectedCategories = $('input[name="category[]"]:checked').map(function() {
            return $(this).val();
        }).get();

        $.ajax({
            url: ajax_posts_params.ajax_url,
            method: 'POST',
            data: {
                action: 'ajax_fetch_posts',
                nonce: ajax_posts_params.nonce,
                categories: selectedCategories,
                paged: page,
            },
            beforeSend: function() {
                $('#posts-list').html('<p>Loading...</p>');
            },
            success: function(response) {
                $('#posts-list').html(response);
            },
        });
    }

    // Fetch posts on page load
    fetchPosts();

    // Fetch posts on category filter change
    $('input[name="category[]"]').on('change', function() {
        fetchPosts();

        // Update active class for labels
        $('input[name="category[]"]').each(function() {
            const label = $(this).closest('.category-label');
            if ($(this).is(':checked')) {
                label.addClass('active');
            } else {
                label.removeClass('active');
            }
        });
    });

    // Handle pagination
    $(document).on('click', '#pagination a', function(e) {
        e.preventDefault();
        const page = $(this).attr('href').split('paged=')[1];
        fetchPosts(page);
    });

    // Add or remove active class on label click
    $('.category-label').on('click', function() {
        const checkbox = $(this).find('input[name="category[]"]');
        checkbox.prop('checked', !checkbox.prop('checked')).trigger('change');
    });
});


document.querySelectorAll('.twbb-nav-menu a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function (e) {
        e.preventDefault();
        const targetId = this.getAttribute('href');
        if (targetId && targetId !== "#") {
            const targetElement = document.querySelector(targetId);
            if (targetElement) {
                targetElement.scrollIntoView({ behavior: 'smooth' });
            }
        }
    });
});

// Get the video element
const videoElement = document.querySelector('video');
document.getElementById('mute-btn').classList.add('hidden-el'); 
// Function to unmute the video
function unmuteVideo() {
    if (videoElement) {
      	document.getElementById('unmute-btn').classList.add('hidden-el'); 
      	document.getElementById('mute-btn').classList.remove('hidden-el'); 
        videoElement.muted = false;
    }
}

// Function to mute the video
function muteVideo() {
    if (videoElement) {
        document.getElementById('mute-btn').classList.add('hidden-el'); 
      	document.getElementById('unmute-btn').classList.remove('hidden-el'); 
        videoElement.muted = true;
    }
}

// Add an event listener to the element with the '.unmute' class
document.querySelector('#unmute-btn').addEventListener('click', unmuteVideo);

// Add an event listener to the element with the '.mute' class
document.querySelector('#mute-btn').addEventListener('click', muteVideo);

console.log("HERE33");
// Add class when the page is scrolled
window.addEventListener('scroll', function() {
    const header = document.querySelector('.site-header-block');
    
    // Check if the page has been scrolled down
    if (window.scrollY > 100) {
      header.classList.add('sticky');
    } else {
      header.classList.remove('sticky');
    }
  });