<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( !function_exists( 'chld_thm_cfg_locale_css' ) ):
    function chld_thm_cfg_locale_css( $uri ){
        if ( empty( $uri ) && is_rtl() && file_exists( get_template_directory() . '/rtl.css' ) )
            $uri = get_template_directory_uri() . '/rtl.css';
        return $uri;
    }
endif;
add_filter( 'locale_stylesheet_uri', 'chld_thm_cfg_locale_css' );

if ( !function_exists( 'chld_thm_cfg_parent_css' ) ):
    function chld_thm_cfg_parent_css() {
        wp_enqueue_style( 'chld_thm_cfg_parent', trailingslashit( get_template_directory_uri() ) . 'style.css', array( 'tenweb-website-builder-theme-style' ) );
    }
endif;
add_action( 'wp_enqueue_scripts', 'chld_thm_cfg_parent_css', 10 );
         
if ( !function_exists( 'child_theme_configurator_css' ) ):
    function child_theme_configurator_css() {
        wp_enqueue_style( 'chld_thm_cfg_child', trailingslashit( get_stylesheet_directory_uri() ) . 'style.css', array( 'chld_thm_cfg_parent' ) );
    }
endif;
add_action( 'wp_enqueue_scripts', 'child_theme_configurator_css', 10 );

// END ENQUEUE PARENT ACTION


function categories_with_pagination_shortcode($atts) {
    // Attributes and defaults
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 10, // Categories per page
        ),
        $atts,
        'categories_pagination'
    );

    // Get current page
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

    // Arguments for WP_Term_Query
    $args = array(
        'taxonomy'   => 'category',
        'orderby'    => 'name',
        'order'      => 'ASC',
        'hide_empty' => false,
        'number'     => $atts['posts_per_page'],
        'offset'     => ($paged - 1) * $atts['posts_per_page'],
    );

    // Fetch categories
    $categories = get_terms($args);

    // Check if categories exist
    if (empty($categories)) {
        return '<p>No categories found.</p>';
    }

    // Start output buffering
    ob_start();
    $html = '';
    $html .= '<div class="elementor">';
    $html .= '<div class="elementor-element elementor-element-7e39c1d7 e-flex e-con-boxed e-con e-parent e-lazyloaded">';
    $html .= '<div class="e-con-inner">';
    $html .= '<div class="elementor-element elementor-element-64d12396 twbb-posts-grid-3 twbb-posts-grid-tablet-2 twbb-posts-grid-mobile-1 elementor-widget elementor-widget-twbb-posts-archive">';
    $html .= '<div class="elementor-widget-container">';
    $html .= '<div class="twbb-posts-widget-container twbb-posts-grid-container">';
    
    foreach ($categories as $category) {
        $image = get_field('image', 'category_' . $category->term_id);
        $html .= '<div class="twbb-posts-item">';
        $html .= '<a href="' . esc_url(get_category_link($category->term_id)) . '"><img src="' . esc_url($image) . '"></a>';
        $html .= '<h2>';
        $html .= '<a href="' . esc_url(get_category_link($category->term_id)) . '">';
        $html .= esc_html($category->name);
        $html .= '</a>';
        $html .= '</h2>';
        $html .= '<div class="desc">'.wp_trim_words( $category->description, 30, '...' ).'</div>';
        $html .= '</div>';
    }

    $html .= '</div>';
    $html .= '</div>';
    $html .= '</div>';
    $html .= '</div>';
    $html .= '</div>';

    // Pagination
    $total_categories = wp_count_terms(array('taxonomy' => 'category', 'hide_empty' => false));
    $total_pages = ceil($total_categories / $atts['posts_per_page']);

    if ($total_pages > 1) {
        $html .= '<div class="categories-pagination">';
        $html .= paginate_links(array(
            'base'      => get_pagenum_link(1) . '%_%',
            'format'    => 'page/%#%',
            'current'   => max(1, $paged),
            'total'     => $total_pages,
            'prev_text' => __('« Previous'),
            'next_text' => __('Next »'),
        ));
        $html .= '</div>';
    }
    echo $html;
    // Return buffered content
    return ob_get_clean();
}
add_shortcode('categories_pagination', 'categories_with_pagination_shortcode');


function enqueue_ajax_scripts() {
    wp_enqueue_script('ajax-posts', get_stylesheet_directory_uri() . '/js/ajax-posts.js', ['jquery'], null, true);

    wp_localize_script('ajax-posts', 'ajax_posts_params', [
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce'    => wp_create_nonce('ajax-posts-nonce'),
    ]);
}
add_action('wp_enqueue_scripts', 'enqueue_ajax_scripts');


function ajax_fetch_posts() {
    check_ajax_referer('ajax-posts-nonce', 'nonce');

    $paged = isset($_POST['paged']) ? intval($_POST['paged']) : 1;
    $categories = isset($_POST['categories']) ? array_map('intval', $_POST['categories']) : [];

    $args = [
        'post_type'      => 'post',
        'posts_per_page' => 9,
        'paged'          => $paged,
        'orderby'        => 'date',
        'order'          => 'DESC',
    ];

    if (!empty($categories)) {
        $args['tax_query'] = [
            [
                'taxonomy' => 'category',
                'field'    => 'term_id',
                'terms'    => $categories,
            ],
        ];
    }

    $query = new WP_Query($args);

    if ($query->have_posts()) :
        while ($query->have_posts()) : $query->the_post(); ?>
            <div class="post-item">
                <div class="post-img-box"><a href="<?php echo get_the_permalink(); ?>"><img src="<?php echo get_the_post_thumbnail_url(get_the_ID(), 'thumbnail');?>"></a></div>
                <div class="post-content-box">
                    <h3><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(get_the_ID()); ?></a></h3>
                    <div class="post-desc"><?php echo wp_trim_words( get_the_content(get_the_ID()), 30, '...' ); ?></div>
                </div>
            </div>
        <?php endwhile;
        echo '<div class="pagination" id="pagination">';
        // Pagination
        echo paginate_links([
            'total'   => $query->max_num_pages,
            'current' => $paged,
            'format'  => '?paged=%#%',
        ]);
        echo '</div>';
    else :
        echo '<p>No posts found.</p>';
    endif;

    wp_reset_postdata();
    wp_die();
}
add_action('wp_ajax_nopriv_ajax_fetch_posts', 'ajax_fetch_posts');
add_action('wp_ajax_ajax_fetch_posts', 'ajax_fetch_posts');


function ajax_post_listing_shortcode() {
    ob_start(); ?>
    
    <div id="ajax-posts-container">
        <div class="category-filter">
            <?php 
            $categories = get_categories();
            foreach ($categories as $category) : ?>
                <label class="category-label">
                    <input type="checkbox" name="category[]" value="<?php echo esc_attr($category->term_id); ?>" > 
                    <?php echo esc_html($category->name); ?>
                </label>
            <?php endforeach; ?>
        </div>

        <div class="posts-list-wrap"><div id="posts-list"></div></div>
    </div>

    <?php return ob_get_clean();
}
add_shortcode('ajax_post_listing', 'ajax_post_listing_shortcode');
