jQuery( window ).on( 'elementor/frontend/init', function () {
    jQuery(document).on('mouseenter', '.elementor-widget-twbb_woocommerce-products[data-widget_type="twbb_woocommerce-products.modern"].product_buttons_visibility__show_on_hover .product', function() {
        jQuery(this).find('.twbb-add_to_cart_container_open').css({'display':'flex'});
        let buttonsContainerHeight = parseInt(jQuery(this).find('.twbb-add_to_cart_container_open').outerHeight());
        jQuery(this).find('.product_info_div').css('bottom',buttonsContainerHeight + 'px');
    })
    jQuery(document).on('mouseleave ', '.elementor-widget-twbb_woocommerce-products[data-widget_type="twbb_woocommerce-products.modern"].product_buttons_visibility__show_on_hover .product', function() {
        jQuery(this).find('.twbb-add_to_cart_container_open').css({'display':'none'});
        jQuery(this).find('.product_info_div').css('bottom',0);
    })


    jQuery('.twbb_woocommerce-products-ajax-paginate .page-numbers li').on('click', function(e) {
        e.preventDefault();
        productsAjaxPagination(jQuery(this));
    });
    jQuery('.elementor-widget-twbb_woocommerce-products .add_to_cart_button').on('click',function() {
        changeProductQuantity(this);
    });
    /*
    10web customization
    */
    jQuery(document).on('click', '.elementor-widget-twbb_woocommerce-products .twbb-product-quantity-change', function() {
        var $input = jQuery(this).parent().find('input');
        if ( jQuery(this).hasClass( 'twbb-minus-quantity' ) ) {
            $input.val(parseInt($input.val()) - 1);
        } else {
            $input.val(parseInt($input.val()) + 1);
        }
        $input.change();
        jQuery('button[name=update_cart]').trigger('click');
        return false;
    });

    jQuery('.twbb-woocommerce-products-variations img').on('mouseenter', function() {
        var src = jQuery(this).attr('src');
        var product = jQuery(this).closest('.twbb-woocommerce-products-variations').parent();
        var product_link = product.attr('href');
        var attrs = {};
        jQuery.each( jQuery(this).attr('data-attrs_as_params').split('&'), function(dataKey, dataValue){
            if( dataValue ) {
                let key, val;
                key = dataValue.split('=')[0];
                val = dataValue.split('=')[1];
                attrs[key] = val;
            }
        })
        var new_link = add_params_to_product_link(product_link, attrs);
        product.attr('href', new_link);
        jQuery(this).closest('.twbb-woocommerce-products-variations').parent().find('>img').removeAttr('srcset').attr('src', src);
    });

    jQuery(document).on('click', '.add_to_cart_button', function(){
        jQuery(this).addClass('twbb-change-button-text').text('Added');
        setTimeout(function(){
            jQuery('.add_to_cart_button.twbb-change-button-text').text('Add to cart');
        },1000);})

    /*
      end customization
    */
})

function add_params_to_product_link( link, attrs) {
    let url, new_params, new_link;
    url = new URL(link).searchParams;
    Object.keys(attrs).forEach(function(key) {
        url.set(key, attrs[key]);
    });
    new_params = url.toString();
    new_link = link.split('?')[0] + '?' + new_params;
    return new_link;
}

function productsAjaxPagination(element) {
    const url = element.find('a').attr('href');
    const container = element.closest('.elementor-widget-twbb_woocommerce-products');
    const container_id = element.closest('.elementor-widget-twbb_woocommerce-products').data('id');
    jQuery.ajax({
        url: url,
        type:'GET',
        dataType: 'html',
        success: function(data){
            let parser = new DOMParser();
            const doc = parser.parseFromString(data, 'text/html');
            const new_page = jQuery(doc).find('.elementor-widget-twbb_woocommerce-products[data-id="' + container_id + '"]').html();
            container.html(new_page);
            jQuery('.twbb_woocommerce-products-ajax-paginate .page-numbers li').on('click', function(e) {
                e.preventDefault();
                productsAjaxPagination(jQuery(this));
            })
        }
    })
}

function changeProductQuantity(that) {
    let input_value = jQuery(that).closest('li.product').find('input.twbb-product-quantity-input').val();
    jQuery(that).attr('data-quantity',input_value);
}
