<?php

namespace Tenweb_Builder\Apps;

class CoPilot extends BaseApp
{
    protected static $instance = null;

    public static function getInstance(){
        if(is_null(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }


    public function __construct()
    {
        if( !$this->checkVisibility() ) {
            return false;
        }
        $this->addActions();
    }

    public function checkVisibility() {
        if ( get_option('elementor_experiment-co_pilot') !== 'active' ) {
            return FALSE;
        }
        return TRUE;
    }
    private function addActions() {
        add_action('elementor/editor/after_enqueue_styles', array( $this, 'enqueueEditorScripts' ));
        add_action('elementor/editor/footer', array($this, 'set_templates'));
    }

    /**
     * Include HTML templates
     */
    public function set_templates() {
        require_once (TWBB_DIR . '/Apps/CoPilot/templates.php');
    }

    public function enqueueEditorScripts() {

        wp_enqueue_script('twbb-copilot-firebase-app', "https://www.gstatic.com/firebasejs/10.12.4/firebase-app-compat.js");
        wp_enqueue_script('twbb-copilot-firebase-firestore', "https://www.gstatic.com/firebasejs/10.12.4/firebase-firestore-compat.js");
        wp_enqueue_script('twbb-copilot-firebase-auth', "https://www.gstatic.com/firebasejs/10.12.4/firebase-auth-compat.js");
        wp_enqueue_script('twbb-copilot-showdown', "https://unpkg.com/showdown/dist/showdown.min.js");
        wp_enqueue_script('twbb-copilot-script-utils', TWBB_URL . "/Apps/CoPilot/assets/js/utils.js", array('jquery'), TWBB_VERSION);
        wp_enqueue_script('twbb-copilot-widget_settings', TWBB_URL . "/Apps/CoPilot/assets/js/widget_settings.js", array('jquery'), TWBB_VERSION);
        wp_enqueue_script('twbb-copilot-elementor_tree', TWBB_URL . "/Apps/CoPilot/assets/js/elementor_tree.js", array('jquery'), TWBB_VERSION);
        wp_enqueue_script('twbb-copilot-update_elementor_tree', TWBB_URL . "/Apps/CoPilot/assets/js/update_elementor_tree.js", array('jquery'), TWBB_VERSION);
        wp_enqueue_script('twbb-copilot-script', TWBB_URL . "/Apps/CoPilot/assets/js/script.js", array('jquery'), TWBB_VERSION);

        $accessToken = get_site_option('tenweb_access_token');
        $wpUserId = get_current_user_id();
        $pageId = get_the_ID();
        $domainId = get_site_option('tenweb_domain_id');
        $workspaceId = get_site_option('tenweb_workspace_id');
        $ai_assistant_url = rtrim(TENWEB_AI_ASSISTANT, '/');
        $customTokenApi = $ai_assistant_url . '/copilot/workspaces/' . get_site_option('tenweb_workspace_id') . '/domains/'.get_site_option('tenweb_domain_id').'/firebase-token';

        $clearChatUrl = $ai_assistant_url."/copilot/workspaces/".$workspaceId."/domains/".$domainId."/pages/".$pageId;
        $feedBackApi = $ai_assistant_url."/copilot/workspaces/".$workspaceId."/domains/".$domainId."/feedback";
        $testMode = $_GET['tenweb_copilot_test_mode'] ?? null;
        $testModeApi = $_GET['tenweb_copilot_test_mode_api'] ?? null;
        global $tenweb_firebaseConfig;
        wp_localize_script('twbb-copilot-script', 'twbb_chat',
            array(
                'accessToken'    => $accessToken,
                'wpUserId'       => $wpUserId,
                'pageId'         => $pageId,
                'domainId'       => $domainId,
                'workspaceId'    => $workspaceId,
                'customTokenApi' => $customTokenApi,
                'clearChatUrl'   => $clearChatUrl,
                'feedBackApi'    => $feedBackApi,
                'twbb_sg_nonce'  => wp_create_nonce('twbb-sg-nonce'),
                'firebaseConfig' => $tenweb_firebaseConfig,
                'testMode'       => $testMode,
                'testModeApi'    => $testModeApi,

            ));

        wp_enqueue_style('twbb-copilot-style', TWBB_URL . "/Apps/CoPilot/assets/css/style.css", array(), TWBB_VERSION);
    }
}